/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.BloodMagic;
import wayoftime.bloodmagic.recipe.RecipeARC;
import wayoftime.bloodmagic.recipe.helper.FluidStackIngredient;
import wayoftime.bloodmagic.recipe.helper.SerializerHelper;

public class ARCRecipeSerializer<RECIPE extends RecipeARC>
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;

    public ARCRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @Nonnull
    public RECIPE fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        JsonArray input = GsonHelper.m_13885_((JsonObject)json, (String)"input") ? GsonHelper.m_13933_((JsonObject)json, (String)"input") : GsonHelper.m_13930_((JsonObject)json, (String)"input");
        int inputSize = GsonHelper.m_13927_((JsonObject)json, (String)"inputsize");
        JsonArray tool = GsonHelper.m_13885_((JsonObject)json, (String)"tool") ? GsonHelper.m_13933_((JsonObject)json, (String)"tool") : GsonHelper.m_13930_((JsonObject)json, (String)"tool");
        Ingredient inputIng = Ingredient.m_43917_((JsonElement)input);
        Ingredient toolIng = Ingredient.m_43917_((JsonElement)tool);
        ItemStack output = SerializerHelper.getItemStack(json, "output");
        ArrayList<Pair<ItemStack, Pair<Double, Double>>> addedItems = new ArrayList<Pair<ItemStack, Pair<Double, Double>>>();
        if (json.has("addedoutput") && GsonHelper.m_13885_((JsonObject)json, (String)"addedoutput")) {
            JsonArray mainArray = GsonHelper.m_13933_((JsonObject)json, (String)"addedoutput");
            for (JsonElement element : mainArray) {
                if (addedItems.size() >= 3) break;
                if (!element.isJsonObject()) continue;
                JsonObject obj = element.getAsJsonObject();
                double mainChance = GsonHelper.m_13915_((JsonObject)obj, (String)"mainchance");
                double secondaryChance = GsonHelper.m_13915_((JsonObject)obj, (String)"chance");
                ItemStack extraDrop = SerializerHelper.getItemStack(obj, "type");
                addedItems.add((Pair<ItemStack, Pair<Double, Double>>)Pair.of((Object)extraDrop, (Object)Pair.of((Object)mainChance, (Object)secondaryChance)));
            }
        }
        FluidStackIngredient inputFluidIng = null;
        if (json.has("inputFluid")) {
            JsonArray inputFluid = GsonHelper.m_13885_((JsonObject)json, (String)"inputFluid") ? GsonHelper.m_13933_((JsonObject)json, (String)"inputFluid") : GsonHelper.m_13930_((JsonObject)json, (String)"inputFluid");
            inputFluidIng = FluidStackIngredient.deserialize((JsonElement)inputFluid);
        }
        FluidStack outputFluidStack = FluidStack.EMPTY;
        if (json.has("outputFluid")) {
            JsonObject outputFluid = GsonHelper.m_13930_((JsonObject)json, (String)"outputFluid").getAsJsonObject();
            outputFluidStack = SerializerHelper.deserializeFluid(outputFluid);
        }
        boolean consumeIngredient = GsonHelper.m_13912_((JsonObject)json, (String)"consumeingredient");
        return this.factory.create(recipeId, inputIng, inputSize, toolIng, inputFluidIng, output, addedItems, outputFluidStack, consumeIngredient);
    }

    public RECIPE fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        try {
            ArrayList<Pair<ItemStack, Pair<Double, Double>>> addedItems = new ArrayList<Pair<ItemStack, Pair<Double, Double>>>();
            Ingredient inputIng = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            int inputSize = buffer.readInt();
            Ingredient toolIng = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack output = buffer.m_130267_();
            int addedItemSize = buffer.readInt();
            for (int i = 0; i < addedItemSize; ++i) {
                ItemStack stack = buffer.m_130267_();
                double mainChance = buffer.readDouble();
                double secondaryChance = buffer.readDouble();
                addedItems.add(Pair.of((Object)stack, (Object)Pair.of((Object)mainChance, (Object)secondaryChance)));
            }
            FluidStackIngredient inputFluid = null;
            FluidStack outputFluid = new FluidStack(Fluids.f_76191_, 1000);
            if (buffer.readBoolean()) {
                inputFluid = FluidStackIngredient.read(buffer);
            }
            if (buffer.readBoolean()) {
                outputFluid = FluidStack.readFromPacket((FriendlyByteBuf)buffer);
            }
            boolean consumeIngredient = buffer.readBoolean();
            return this.factory.create(recipeId, inputIng, inputSize, toolIng, inputFluid, output, addedItems, outputFluid, consumeIngredient);
        }
        catch (Exception e) {
            BloodMagic.LOGGER.error("Error reading ARC recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull RECIPE recipe) {
        try {
            ((RecipeARC)recipe).write(buffer);
        }
        catch (Exception e) {
            BloodMagic.LOGGER.error("Error writing ARC recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends RecipeARC> {
        public RECIPE create(ResourceLocation var1, Ingredient var2, int var3, Ingredient var4, FluidStackIngredient var5, ItemStack var6, List<Pair<ItemStack, Pair<Double, Double>>> var7, FluidStack var8, boolean var9);
    }
}

